#**************************************************************************/
#* FILE NAME:                              COPYRIGHT (c) Freescale 2012   */
#* Vector_SW_VLE - Z4.s                             All Rights Reserved   */
#*                                                                        */
#* DESCRIPTION:                                                           */
#* This is a generic base template for setting up the IVPR and IVOR       */
#* registers for the e200z4                                               */
#*                                                                        */
#* This file also includes a trap for all core exceptions, excluding      */
#* IVOR4 exceptions which have seperate handler                           */
#*                                                                        */
#* Syntax specifically written for GHS v5.x compiler. This file starts in */
#* memory at the beginning of the ".xptn_vectors" section.                */
#**************************************************************************/	
#* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE               */
#* ---   -----------    ----------    ---------------------               */
#* 1.0	  D.McMenamin    13/Sept/12   Initial Public Release              */
#**************************************************************************/
 
  .globl      e200zX_Interrupt_Setup
  .extern     IVOR4_Handler
   
  .section    .xptn_vectors, axv
  .vle

IVORnTable:    
#=================================================
#               IVOR 0 Vector
#=================================================           
IVOR0_Vector:
    nop
    e_b IVOR0_Vector
#=================================================
#               IVOR 1 Vector
#=================================================           
.offset 0x10
IVOR1_Vector:
    nop
    e_b IVOR1_Vector
#=================================================
#               IVOR 2 Vector
#=================================================              
.offset 0x20
IVOR2_Vector:
    nop
    e_b IVOR2_Vector
#=================================================
#               IVOR 3 Vector
#=================================================              
.offset 0x30
IVOR3_Vector:
    nop
    e_b IVOR3_Vector
#=================================================
#               IVOR 4 Vector
#=================================================              
.offset 0x40
IVOR4_Vector:
    e_b IVOR4_Handler
#     e_b IVOR4_Vector     
#=================================================
#               IVOR 5 Vector
#=================================================              
.offset 0x50
IVOR5_Vector:
    nop
    e_b IVOR5_Vector
#=================================================
#               IVOR 6 Vector
#=================================================              
.offset 0x60
IVOR6_Vector:
    nop
    e_b IVOR6_Vector
#=================================================
#               IVOR 7 Vector
#=================================================              
.offset 0x70
IVOR7_Vector:
    nop
    e_b IVOR7_Vector
#=================================================
#               IVOR 8 Vector
#=================================================              
.offset 0x80
IVOR8_Vector:
    nop
    e_b IVOR8_Vector
#=================================================
#               IVOR 9 Vector
#=================================================              
.offset 0x90
IVOR9_Vector:
    nop
    e_b IVOR9_Vector
#=================================================
#               IVOR 10 Vector
#=================================================              
.offset 0xA0
IVOR10_Vector:
    nop
    e_b IVOR10_Vector    
#=================================================
#               IVOR 11 Vector
#=================================================              
.offset 0xB0
IVOR11_Vector:
    nop
    e_b IVOR11_Vector    
#=================================================
#               IVOR 12 Vector
#=================================================              
.offset 0xC0
IVOR12_Vector:
    nop
    e_b IVOR12_Vector
#=================================================
#               IVOR 13 Vector
#=================================================              
.offset 0xD0
IVOR13_Vector:
    nop
    e_b IVOR13_Vector
#=================================================
#               IVOR 14 Vector
#=================================================              
.offset 0xE0
IVOR14_Vector:
    nop
    e_b IVOR14_Vector                                                  
#=================================================
#               IVOR 15 Vector
#=================================================              
.offset 0xF0
IVOR15_Vector:                             
    nop                           
    e_b IVOR15_Vector                                                              
    
#.fsize 0
.scall __leaf__
.type e200zX_Interrupt_Setup,@function

#=================================================
#  Function to Setup the Core Interrupt Registers
#=================================================              
e200zX_Interrupt_Setup:
    #IVPR = address base used with IVOR's
    e_lis r5, __IVPR@h   
    e_or2i r5, __IVPR@l
    mtIVPR r5 
    se_blr
    
.size e200zX_Interrupt_Setup,$-e200zX_Interrupt_Setup
